<?php

return function($app, $server, $interval, $getVersion) {
  // is $v1 > $v2 (ist $v1 neuer als $v2?)
  $version_is_newer = function ($v1, $v2) {
    return ($v1 > $v2) ? true : false;
  };
  
  $lockFilename = 'next-call-home';
  $currentVersion = $getVersion();
  try {

    if (file_exists($lockFilename)) {
      $lockData = json_decode(file_get_contents($lockFilename));
      if (!$lockData || !is_object($lockData)) {
        unset($lockData);
      }
    }
    
    if (isset($lockData)) {
      $nextCall = $lockData->nextCall;
      if (preg_match('`^\d+-\d+-\d+ \d+:\d+:\d+$`', $nextCall)) {
        $nextCall = new \DateTime($nextCall);
        $now = new \DateTime();
        if ($now < $nextCall) {
          // nicht prüfen - Ergebnis letzter prüfung zurück geben
          // falls alter stand gespeichert wurde und bereits eine neuere Version installiert ist
          if (($lockData->updates->latestFull ?? null) && !$version_is_newer($lockData->updates->latestFull, $currentVersion)) {
            $lockData->updates->latestFull = null;
          }
          if (($lockData->updates->latestUpdate ?? null) && !$version_is_newer($lockData->updates->latestUpdate, $currentVersion)) {
            $lockData->updates->latestUpdate = null;
          }
          return $lockData->updates;
        }
      }
    }
    
    $interval = new \DateInterval($interval);
    $nextCall = new \DateTime();
    $nextCall->add($interval);
    $lockData = (object)[
        'nextCall'=>$nextCall->format('Y-m-d H:i:s'),
        'updates'=> null,
    ];
    //console('CALL HOME');
    $ctx = stream_context_create([
      'http' => [
        'timeout' => 10,
      ]
    ]);
    $checkUrl = $server . $app . '/available_versions?elm&currentVersion='.$currentVersion;
    $result = @file_get_contents($checkUrl, 0, $ctx);
    if ($result === false) {
      return null;
    }
    $jsonData = json_decode($result);
    if (!is_array($jsonData)) {
      $lockData->updates = null;
      return null;
    }
    $latestUpdate = null;
    $latestFull = null;
    foreach ($jsonData as $vObj) {
      if ($version_is_newer($vObj->version, $currentVersion)) {
        switch ($vObj->type) {
          case 'update':
            // Wir suchen das erste Update nach der aktuellen Version, damit wir inkrementell vorgehen können
            if (is_null($latestUpdate) || $version_is_newer($latestUpdate, $vObj->version)) {
              $latestUpdate = $vObj->version;
            }
            break;
          case 'full':
            // wir suchen die neueste Voll-Version
            if (is_null($latestFull) || $version_is_newer($vObj->version, $latestFull)) {
              $latestFull = $vObj->version;
            }
            break;
        }
      }
    }
    if (!$latestFull && !$latestUpdate) {
      $lockData->updates = null;
      return null;
    }
    
    $lockData->updates = (object)[
        'latestFull'   => $latestFull,
        'latestUpdate' => $latestUpdate
    ];
    return $lockData->updates;
  } catch (\Throwable $ex) {  echo $ex->getMessage();}
  finally {
    file_put_contents($lockFilename, json_encode($lockData));
  }
};
