# Cy4Marktzeitung

Dieses Tool ist ein Extrakt von CyWeb: Es umfasst nur die Erstellung einer PDF-Markzeitung aber für Cyclos 4.x ... (siehe CHANGELOG.md)

## Installation / Konfiguration

Kopie von `dist.config.php` als `config.php` speichern und anpassen. Änderungen an dieser Datei sollten durch ein Update nicht überschrieben werden.

`define('TOC', true);` aktiviert Inhaltsverzeichnis.

### Cyclos-Zugang

Konfigurieren Sie mit den Optionen `CYCLOS_API_URL`, `CYCLOS_API_USER` und `CYCLOS_API_PASSWORD` den Zugang zum Cyclos-Server.

### Trade-Type: Angebote vs. Gesuche

Ab Cyclos 4 ist der `tradeType` (Angebot / Gesuch) nicht mehr fester Bestandteil eines Inserates und man muss diese Funktion als customField umsetzen. Cy4Marktzeitung setzt aber weiterhin auf eine Einteilung in Angebote und Gesuche. Man muss der Software also mitteilen, welches Feld und welche Werte diese Bedeutung haben.
Mit `TRADE_TYPE_CUSTOM_FIELD` definiert man den internen Namen des Feldes, in dem der Trade Type gespeichert ist.

Dann legt man in `TRADE_TYPE_ORDER` mit Schlüsselworten fest, welche TradeTypes es gibt und in welcher Reihenfolge sie erscheinen sollen. Zum Beispiel:

`define('TRADE_TYPE_ORDER', ['SEARCH', 'OFFER']);`

Wenn man mehr Typen hat muss diese Liste entsprechend erweitert werden.

Für jeden Eintrag in dieser Liste definiert man nun:

- `TRADE_TYPE_{Schlüsselwort}_TITLE`: Überschrift für den Typ
- `TRADE_TYPE_{Schlüsselwort}_INTERNAL_VALUE`: interner Name des möglichen Wertes für den Trade Type

### Cache

Die Cache-Funktion kann mit den Optionen `PDF_CACHE`, `PDF_CACHE_TIME` und `PDF_CACHE_PATH` konfiguriert werden.
Ggf. muss das angegebene Verzeichnis schreibbar gemacht werden.
Wenn Sie unterschiedliche Konfigurationen verwenden, lohnt es sich zu prüfen, ob auch unterschiedliche Cache-Ordner verwendet werden müssen.

### Mehrere parallele Konfigurationen

Um das Tool mit unterschiedlichen Konfigurationen zu betreiben, muss man es nicht mehrfach installieren. Kopieren Sie die Datei `index.php` (z.B. als `markt2.php`) und legen Sie eine dem Zweck angepasste weitere Kopie der `dist.config.php` (z.B. `markt2.config.php`) an. Gegebenenfalls brauchen Sie auch eine angepasste Variante Ihrer `custom_functions.php`. In der Datei `markt2.php` passen Sie dann folgende Zeilen an:
```
$custom_functions = 'custom_functions.php';
$config = 'config.php';
```
zu
```
$custom_functions = 'markt2.custom_functions.php';
$config = 'markt2.config.php';
```
### Vorgeschaltetes Web-Interface

Um den Abruf der PDF (bei längerer Verarbeitungzeit) benutzerfreudlicher zu gestalten,
wird der PDF-Produktion eine Web-Oberfläche vorgeschaltet. Wird das Tool über Kommandozeile benutzt passiert das natürlich nicht.
Man kann das folgendermaßen deaktivieren: `define('USE_WEB_INTERFACE', false);`


## Verfügbare Felder

Im Template für Inserate (Option `PDF_AD_TEMPLATE`) können diese Felder über Platzhalter (`###feldname###`) eingefügt werden:

  - `title`: Name des Inserates
  - `etitle`: Name des Inserates, escaped für Email-Link
  - `description`
  - `date`: Start-Datum
  - `publication_end`: End-Datum
  - `username`: Username des Mitglieds
  - `name`: Name des Mitglieds
  - `email`: Mail-Adresse des Mitglieds
  - `image`: HTML zum Anzeigen des ersten Bildes des Inserates oder nichts.
  - `address`: Vordefiniertes Extra-Feld: die erste sichtbare Adresse des Mitglieds (nicht des Inserates,  siehe *Extra-Felder*)

  - `field.*`: die Custom Fields des Inserates
  - `ownerfield.*`: die Custom Fields des Mitglieds

  - `phone` (als Extra-Feld): die erste sichtbare Telefonnummer des Mitglieds (siehe *Extra-Felder*)
  - `image` (als Extra-Feld): das erste Bild als fertiges HTML-Tag; konfigurierbar mit `IMAGE_WRAPPER_ATTRIBUTES` und `IMAGE_ATTRIBUTES`
  - `price` (als Extra-Feld): der Preis; Bei der Formatierung wird berücksichtigt: Anzahl der Nachkommastellen, Prefix und Suffix wie in der Währung unter Cyclos konfiguriert, sowie die Konstanten `DEC_POINT` (Dezimalkomma) und `THOUSENDS_SEPARATOR` (Tausenderpunkt).

**Achtung**: Ist der Wert eines Custom Fields kein einfacherer Wert wie Zeichenkette oder Zahl kann dieser _nicht_ über `field.*` bzw. `ownerfield.*`
verwendet werden. Dazu muss ein *Extra-Feld* registriert werden, siehe *Weitergehende Anpassungen*. (Ein Datum ist beispielsweise kein "einfacher Wert").

## Weitergehende Anpassungen

Weitere Anpassungen des Verhaltens können über Programmierung in beschränktem Maße auf folgende Weise erfolgen:

Legen Sie eine Datei mit dem Namen `custom_functions.php` an, so wird diese anstelle von `default_functions.php` verwendet.
Wollen Sie den Code aus `default_functions.php` lediglich erweitern und nicht komplett überschreiben, beginnen Sie die Datei
`custom_functions.php` mit:

```
<?php
require_once "default_functions.php";

// hier können verschiedene Dinge ergänzt werden...
```

### HTML-Cleaner

HTML-Tags / -Attribute von der Reinigung ausschließen:
`HTMLCleaner::allowTag(...);`, siehe `default_functions.php`

### Custom-Field-Extraktor

`AdsPDF::$extract_custom_value = ...` setzt eine Callback-Funktion zum Extrahieren des Wertes aus einem Custom-Field-Objekt.

### Extra-Felder

Für bestimmte Fälle reichen die fest definierten Felder (siehe *Verfügbare Felder*) und die einfachen Custom-Fields nicht aus.
Für solche Fälle können neue Felder mit einem Namen und einer Callback-Funktion mit `ExtraFieldManager::register(...);` registriert werden.

In `default_functions.php` sind bereits drei solche Extra-Felder definiert: `address`, `phone`, `price` und `image`.


## CLI und CRON-Aufrufe

Es gibt mehrere Möglichkeiten, die PDF automatisiert erzeugen zu lassen:

### PHP-CLI
```
php index.php
```
Damit wird die Datei `output.pdf` erzeugt.

### wget o.Ä.
```
wget https://..../?output=document
```
Damit wird die Datei `document.pdf` erzeugt.


### In der Konfiguration
```
define('USE_WEB_INTERFACE', false);
define('PDF_OUTPUT_METHODE', 'F');
```
Erzeugt immer `output.pdf`, ohne Ausgabe.
