<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2007 Thomas Waggershauser <waggershauser@airware.de>
*  (c) 2018 Stefan Beyer SEDAT GmbH <stefan@sedat.de>
*  All rights reserved
*
*  This script is part of Cy4Marktzeitung. The Cy4Marktzeitung project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
if (!defined('ENTRY_POINT')) die('Falscher Aufruf');

/**
 * Cyclos-Server--Zugang
 */
define('CYCLOS_API_URL',      '');
define('CYCLOS_API_USER',     '');
define('CYCLOS_API_PASSWORD', '');


/**
 * Trade Type
 */
define('TRADE_TYPE_CUSTOM_FIELD',          'interner Name des Feldes, in dem der Trade Type gespeichert ist');
define('TRADE_TYPE_OFFER_INTERNAL_VALUE',  'interner Name des möglichen Wertes für den Trade Type Angebot');
define('TRADE_TYPE_SEARCH_INTERNAL_VALUE', 'interner Name des möglichen Wertes für den Trade Type Gesuch');

define('AD_SEARCH_ORDER_BY', 'date asc'); // date|distance|price|random|relevance asc|desc

/**
 * template html-string
 *
 * Titel:           title
 *                  etitle (für E-Mail Subject encodiert)
 * Beschreibung:    description
 * Benutzername:    username
 * Name:            name
 * E-Mail:          email
 * Publication:     date
 * Publication-End: publication_end
 * erstes Bild:     image
 * Anzeigenfelder: field.*
 * User-Felder:    ownerfield.*
 */
define ("PDF_AD_TEMPLATE",
'   <h2 style="border-top:black 1px solid; color:black;">###title###</h2>
    ###image###
    <div style="padding:0; margin:0;">###description###</div>
    <div>###date### <big>Preis: ###price###</big></div>
    <div><a href="mailto:###email###?subject=[cyclos-demo] ###etitle###">###email###</a></div>
    <div><b>###username###</b> - ###address### ###phone###</div>'
);



/**
 * Angezeigte Texte (Überschriften) für Angebote bzw. Gesuche
 */
define('TRADE_TYPE_OFFER_TITLE',  "Angebote");
define('TRADE_TYPE_SEARCH_TITLE', "Gesuche");

/**
 * Reihenfolge von Angeboten und Gesuchen
 */
define('TRADE_TYPE_ORDER', ['OFFER', 'SEARCH']);


define('CATALOG_TYPE', 1); // Es werden unterhalb jeder Kategorie die Angebote und Nachfragen ausgeben.
// define('CATALOG_TYPE', 2); // Es werden zuerst alle Angebote und dann alle Nachfragen ausgegeben.


/**
 * header title
 */
define ("PDF_HEADER_TITLE", "Marktzeitung (###count### Inserate)");

/**
 * header description string
 */
define ("PDF_HEADER_STRING", "Datum: " . date('d.m.Y') . "\nROT markierte Einträge sind neue Inserate\nBLAU markierte Einträge sind 1-2 Wochen alte Inserate");

/**
 * image logo
 */
define ("PDF_HEADER_LOGO", "systemLogo.gif");

/**
 * header logo image width [mm]
 */
define ("PDF_HEADER_LOGO_WIDTH", 40);

/**
 * Zusätze für die Bulder
 */
define('IMAGE_WRAPPER_ATTRIBUTES', 'style="text-align:center; background-color:#eee;"');
define('IMAGE_ATTRIBUTES', '');

define('DEC_POINT', ',');
define('THOUSENDS_SEPARATOR', '.');


/**
 * Vorgeschaltete Web-Oberfläche
 */
define('USE_WEB_INTERFACE', true);

define('PDF_OUTPUT_METHODE', 'I');  // 'I' = im Browser oeffnen, 'D' = download, F: Datei

/**
 * HTML-Cleaner verwenden
 */
define('USE_HTML_CLEANER', true);

/**
 * pagelayout
 */
define( "PDF_ANZ_COLS",       2 );   #  2
define( "PDF_COLUMN_WIDTH",  91 );   # 91 (mm)
define( "PDF_COLUMN_SPACE",   2 );   #  2 (mm)

/**
 * pdf-cache
 *
 * PDF_CACHE:       0 ... kein cache (standard)
 *                  1 ... cache
 */
define ("PDF_CACHE", 0);
define ("PDF_CACHE_TIME", 600);
define ("PDF_CACHE_PATH", "cache/");




/**
 * y-position where to perform a break (from top of the page)
 */
define('PDF_MAX_Y', 280);

/**
 * category headline
 */
define('PDF_CATEGORY_DISABLED', false);  # false (sperren: true)
define('PDF_CATEGORY_SPLITCHAR', ":");  # ':' not used?

define('PDF_CATEGORY_MAIN_FONTSIZE', 11);  # 11
define('PDF_CATEGORY_MAIN_HEIGHT', 6);  # 6
define('PDF_CATEGORY_MAIN_BGCOLOR', 150);  # 150
define('PDF_CATEGORY_MAIN_ALIGN', "C");  # 'C','L','R'
define('PDF_CATEGORY_MAIN_BORDER', 0);  # 0

define('PDF_CATEGORY_SUB_FONTSIZE', 9);  # 9
define('PDF_CATEGORY_SUB_HEIGHT', 5);  # 5
define('PDF_CATEGORY_SUB_BGCOLOR', 200);  # 200
define('PDF_CATEGORY_SUB_ALIGN', "C");  # 'C','L','R'
define('PDF_CATEGORY_SUB_BORDER', 0);  # 0

define('PDF_CATEGORY_MARGIN_BOTTOM', 3);

/**
 * TradeType headline
 * mit dem Parameter "top" kann eingestellt werden, dass auf jeder Seite
 * Angebote oder Nachfrage ganz oben steht, der Anzeigetyp (tradeType)
 * kann gesperrt werden, damit der Typ in den einzelnen Inseraten nicht mehr
 * angezeigt wird, bei dieser Umstellung ist es aber notwendig, zuerst die
 * Angebote und dann die Nachfragen zu erzeugen (siehe pdf.php)
 *
 */
define('PDF_TRADETYPE_DISABLED', false);  # false (sperren: true)
define('PDF_TRADETYPE_FONTSIZE', 10);  # 10
define('PDF_TRADETYPE_HEIGHT', 6);  # 6
define('PDF_TRADETYPE_BORDER', 'B');  # 'B'
define('PDF_TRADETYPE_MARGIN_BOTTOM', 1.0);  # 2

define('PDF_TRADETYPE_TOP_FONTSIZE', 12);  # 12
define('PDF_TRADETYPE_TOP_HEIGHT', 8);  # 8
define('PDF_TRADETYPE_TOP_ALIGN', "C");  # "C"
define('PDF_TRADETYPE_TOP_BGCOLOR', "#D0D0D0");  # #D0D0D0
define('PDF_TRADETYPE_TOP_MARGIN_BOTTOM', 2);  # 2

/**
 * ad
 * note: margin-bottom ... at the bottom of each ad
 * color_1Week ... #000000 is black (no color)
 * color_2Week ... #000000 is black (no color)
 */
define('PDF_AD_MARGIN_BOTTOM', 5);
define('PDF_AD_BORDER', '0');  # Zur Zeit nicht unterstützt css verwenden! 0 ... keine Linie, 'B' ... Linie bottom
define('PDF_AD_COLOR_1WEEK', '#CC0000');  # color for 1-Week ads default: red  #CC0000
define('PDF_AD_COLOR_2WEEK', '#0000FF');  # color for 2-Week ads default: blue #0000FF
define('PDF_AD_COLOR_1MONTH', '#000000');  # color for 1-Week ads default: red  #CC0000
define('PDF_AD_COLOR_OLD', '#828282');
define('PDF_AD_FONTSIZE', 10);  # 10

//Filter
define('AD_FILTER', []);




/**
 * Vartikale Abstaände für Tags
 * [vorher, nachher]
 * h: abstand
 * n: wie oft
 * (warum so kompliziert?)
 * Achtung: das pdf-Modul mach hier noch ein paar Dinge "eigenmächtig"
 */
define('TAG_VS', [
  'h2' => [['h' => 0, 'n' => 0], ['h' => 1, 'n' => 1]],
  'div' => [['h' => 0, 'n' => 0], ['h' => 0, 'n' => 0]],
  'img' => [['h' => 0, 'n' => 0], ['h' => 0, 'n' => 0]],
  'p'   => [['h' => 2,   'n' => 1],   ['h' => 2, 'n' => 1]],
  'ul' => [['h' => 0, 'n' => 0], ['h' => 1, 'n' => 0]],
  //'ol'   => [['h' => 0,   'n' => 0],   ['h' => 1, 'n' => 0]],
]);


/**
 * main font name
 */
define ("PDF_FONT_NAME_MAIN", "freesans"); //vera

/**
 * main font size
 */
define ("PDF_FONT_SIZE_MAIN", 8);


/**
 * header margin
 * Abstand header vom oberen Blattrand
 */
define ("PDF_MARGIN_HEADER", 7);

/**
 * header only in first page
 * true ... only on first page
 * false .. header in all pages
 * if true, the margin top is: PDF_MARGIN_HEADER
 */
// derzeit deaktiviert define ("PDF_HEADER_ONLY_FIRSTPAGE", false);


/**
 *images directory
 */
define ("K_PATH_IMAGES", "media/");


/**
 * Externe config für tcpdf aktivieren
 *
 */
define("K_TCPDF_EXTERNAL_CONFIG", 1);


/**
 * installation path
 */
define ("K_PATH_MAIN", dirname(__FILE__)."/TCPDF6/");

/**
 * url path
 */
define ("K_PATH_URL", "http://notreallyused.com/");

/**
 * document creator
 */
define ("PDF_CREATOR", "Cy4Marktzeitung by Stefan Beyer");

/**
 * document author
 */
define ("PDF_AUTHOR", "Cy4Marktzeitung");



/**
 * footer margin
 * Linie und Seitenzahl
 */
define ("PDF_MARGIN_FOOTER", 10);

/**
 * top margin
 */
define ("PDF_MARGIN_TOP", 25);

/**
 * bottom margin
 */
define ("PDF_MARGIN_BOTTOM", 0);

/**
 * left margin
 */
define ("PDF_MARGIN_LEFT", 13);

/**
 * right margin
 */
define ("PDF_MARGIN_RIGHT", 13);


/**
 * data font name
 */
define ("PDF_FONT_NAME_DATA", "freesans"); //verase

/**
 * data font size
 */
define ("PDF_FONT_SIZE_DATA", 8);

/**
 *  scale factor for images (number of points in user unit)
 */
define ("PDF_IMAGE_SCALE_RATIO", 4);





/**
 * path for PDF fonts
 */
//define ("FPDF_FONTPATH", K_PATH_MAIN."fonts/");
define ("K_PATH_FONTS", K_PATH_MAIN."fonts/");

/**
 * cache directory for temporary files (full path)
 */
define ("K_PATH_CACHE", K_PATH_MAIN."cache/");

/**
 * cache directory for temporary files (url path)
 */
//define ("K_PATH_URL_CACHE", K_PATH_URL."cache/");



/**
 * blank image
 */
define ("K_BLANK_IMAGE", K_PATH_IMAGES."_blank.png");

/**
 * page format
 */
define ("PDF_PAGE_FORMAT", "A4");

/**
 * page orientation (P=portrait, L=landscape)
 */
define ("PDF_PAGE_ORIENTATION", "P");

/**
 *  document unit of measure [pt=point, mm=millimeter, cm=centimeter, in=inch]
 */
define ("PDF_UNIT", "mm");

/**
 * magnification factor for titles
 */
define("HEAD_MAGNIFICATION", 1.1);

/**
 * height of cell repect font height
 */
define("K_CELL_HEIGHT_RATIO", 1.25);

/**
 * title magnification respect main font size
 */
define("K_TITLE_MAGNIFICATION", 1.3);

/**
 * reduction factor for small font
 */
define("K_SMALL_RATIO", 2/3);


define('PDF_ALLCATEGORIES_TEXT', 'Alle');
define('PDF_ALLCATEGORIES', false);







# DEBUG
/**
 * Anzahl der verarbeiteten (nicht leeren) Kategorien beschränken
 */
//define('DEBUG_MAX_CATEGORIES', <int>);

/**
 * Beschreibungstext explizit für alle anzeigen setzen
 */
//define('DEBUG_DESCRIPTION', <string>);
//define('DEBUG_DESCRIPTION', true); function debug_description() {return <string>}
