<?php

/* * *************************************************************
 *  Copyright notice
 *
 *  (c) 2007 Original Software by Thomas Waggershauser <waggershauser@airware.de>
 *  (c) 2018 Stefan Beyer SEDAT GmbH <stefan@sedat.de>
 *  All rights reserved
 *
 *  This script is part of Cy4Marktzeitung. The Cy4Marktzeitung project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************* */
if (!defined('ENTRY_POINT'))
  die('Falscher Aufruf');


# Fehler abfangen
if (!isset($config)) {
  dieWithContent('
  ###reason###
  <p>Es ist nicht bekannt, welche Konfigurationsdatei verwendet werden soll.</p>
  ###solution###
  <p>In der Datei <code>' . htmlentities($_SERVER['PHP_SELF']) . '</code> müssen Sie angeben, welche Konfigurationsdatei geladen werden soll.
  Zum Beispiel: <code>$config = "config.php";</code>.</p><p>Das muss vor der Zeile <code>include "pdf.php";</code> geschehen.');
}
if (!file_exists($config)) {
  dieWithContent('
  ###reason###
  <p>Die in der Datei <code>' . htmlentities($_SERVER['PHP_SELF']) . '</code> angegebene Konfigurationsdatei <code>»' . htmlentities($config) . '«</code> existiert nicht.</p>
  ###solution###
  <p>Legen Sie eine Kopie der Datei <code>dist.config.php</code> unter diesem Namen an und passen Sie dort die Konfirguration an, bevor sie es erneut versuchen.</p>
  <h3>Diese Dinge sollten Sie in der Konfigurationsdatei ggf. anpassen:</h3>
  <ul>
    <li>Zugangsdaten zum Cyclos-Server (Zeilen 30 - 32)</li>
    <li>Unterscheidungskriterien für Angebote und Gesuche (Zeilen 63 - 71)</li>
    <li>Vorlage für die Formatierung der gefundenen Anzeigen (Zeilen 49ff)</li>
  </ul>');
}
