<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2018 Stefan Beyer SEDAT GmbH <stefan@sedat.de>
*  All rights reserved
*
*  This script is part of Cy4Marktzeitung. The Cy4Marktzeitung project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
if (!defined('ENTRY_POINT')) die('Falscher Aufruf');


$html = '<h1>WebInterface</h1>';
$html .= '
<script>
  function _generate(e) {
    //e.preventDefault();
    document.getElementById("form").style.display = "none";
    document.getElementById("loader").style.display = "block";
    return true;
  }
</script>
<form id="form" method="post" onsubmit="return _generate(event);">
  <h3>Marktzeitung als PDF</h3>
  <p>Klicken Sie auf »PDF erzeugen« um den Vorgang zu starten.</p>
  <input type="submit" name="generate" value="PDF erzeugen &gt;&gt;" />
</form>
<div id="loader">
  <h3>PDF wird erzeugt</h3>
  <p>Das kann eine Weile dauern…</p>
  <img src="media/loading.gif" />
</div>
';

if (is_object($updateCheck) && $updateCheck->latestFull) {
  $html .= '<p><strong>Neue Version verfügbar: </strong> <a href="'.CALL_HOME_SERVER.CALL_HOME_APP.'/download/?version='. htmlentities($updateCheck->latestFull).'&type=full" target="_blank">'. htmlentities($updateCheck->latestFull).'</a></p>';
}


webPage('Start', $html, '
#loader {
  display:none;
}
#form input[name=generate] {
  border: 1px solid #777;
  border-radius:3px;
  background:#45ab67;
  padding:10px 15px;
  color:#fff;
  cursor:pointer;
}
#form input[name=generate]:hover {
  border: 1px solid #333;
  background:#128956;
}
');
die();
