<?php

/**
 * StepLTest.php
 *
 * @since     2011-05-23
 * @category  Library
 * @package   Unicode
 * @author    Nicola Asuni <info@tecnick.com>
 * @copyright 2011-2024 Nicola Asuni - Tecnick.com LTD
 * @license   http://www.gnu.org/copyleft/lesser.html GNU-LGPL v3 (see LICENSE.TXT)
 * @link      https://github.com/tecnickcom/tc-lib-unicode
 *
 * This file is part of tc-lib-unicode software library.
 */

namespace Test\Bidi;

use Com\Tecnick\Unicode\Bidi\StepL;
use PHPUnit\Framework\TestCase;

/**
 * Bidi Test
 *
 * @since     2011-05-23
 * @category  Library
 * @package   Unicode
 * @author    Nicola Asuni <info@tecnick.com>
 * @copyright 2011-2024 Nicola Asuni - Tecnick.com LTD
 * @license   http://www.gnu.org/copyleft/lesser.html GNU-LGPL v3 (see LICENSE.TXT)
 * @link      https://github.com/tecnickcom/tc-lib-unicode
 */
class StepLTest extends TestCase
{
    /**
     * @dataProvider stepLDataProvider
     *
     * @param array<int, array{
     *                'char': int,
     *                'i': int,
     *                'level': int,
     *                'otype': string,
     *                'pdimatch': int,
     *                'pos': int,
     *                'type': string,
     *                'x': int,
     *              }> $chardata
     */
    public function testStepL(array $chardata, int $pel, int $maxlevel, mixed $expected): void
    {
        $stepl = new StepL($chardata, $pel, $maxlevel);
        $this->assertEquals($expected, $stepl->getChrData());
    }

    /**
     * @return array<int, array{
     *           0: array<int, array{
     *                'char': int,
     *                'i': int,
     *                'level': int,
     *                'otype': string,
     *                'pdimatch': int,
     *                'pos': int,
     *                'type': string,
     *                'x': int,
     *              }>,
     *           1: int,
     *           2: int,
     *           3: array<int, array{
     *                'char': int,
     *                'i': int,
     *                'level': int,
     *                'otype': string,
     *                'pdimatch': int,
     *                'pos': int,
     *                'type': string,
     *                'x': int,
     *              }>,
     *         }>
     */
    public static function stepLDataProvider(): array
    {
        return [
            [
                // car means CAR.
                // 00000000001110
                [
                    [
                        'pos' => 0,
                        'char' => 99,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 114,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 109,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 110,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
                0,
                1,
                // car means RAC.
                [
                    [
                        'pos' => 0,
                        'char' => 99,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 114,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 109,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 110,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
            ],
            [
                // <car MEANS CAR.=
                // 0222111111111110
                [
                    [
                        'pos' => 0,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 99,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 114,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 77,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 78,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 46,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
                0,
                2,
                // <.RAC SNAEM car=
                [
                    [
                        'pos' => 0,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 46,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 78,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 77,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 99,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 114,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
            ],
            [
                // he said "<car MEANS CAR=." "<IT DOES=," she agreed.
                // 000000000022211111111110000001111111000000000000000
                [
                    [
                        'pos' => 0,
                        'char' => 104,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 105,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 100,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 99,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 114,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 77,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 16,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 17,
                        'char' => 78,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 18,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 19,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 20,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 21,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 22,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 23,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 24,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 25,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 26,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 27,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 28,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 29,
                        'char' => 73,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 30,
                        'char' => 84,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 31,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 32,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 33,
                        'char' => 79,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 34,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 35,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 36,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 37,
                        'char' => 44,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 38,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 39,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 40,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 41,
                        'char' => 104,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 42,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 43,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 44,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 45,
                        'char' => 103,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 46,
                        'char' => 114,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 47,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 48,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 49,
                        'char' => 100,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 50,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
                0,
                2,
                // he said "<RAC SNAEM car=." "<SEOD TI=," she agreed.
                [
                    [
                        'pos' => 0,
                        'char' => 104,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 105,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 100,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 22,
                        'char' => 82,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 21,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 20,
                        'char' => 67,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 19,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 18,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 17,
                        'char' => 78,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 16,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 77,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 99,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 114,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 23,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 24,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 25,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 26,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 27,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 28,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 35,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 34,
                        'char' => 69,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 33,
                        'char' => 79,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 32,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 31,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 30,
                        'char' => 84,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 29,
                        'char' => 73,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 36,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 37,
                        'char' => 44,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 38,
                        'char' => 34,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 39,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 40,
                        'char' => 115,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 41,
                        'char' => 104,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 42,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 43,
                        'char' => 32,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 44,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 45,
                        'char' => 103,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 46,
                        'char' => 114,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 47,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 48,
                        'char' => 101,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 49,
                        'char' => 100,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 50,
                        'char' => 46,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
            ],
            [
                // DID YOU SAY '>he said "<car MEANS CAR="='?
                // 111111111111112222222222444333333333322111
                [
                    [
                        'pos' => 0,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 73,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 89,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 79,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 85,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 89,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 39,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 8294,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 104,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 101,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 16,
                        'char' => 32,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 17,
                        'char' => 115,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 18,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 19,
                        'char' => 105,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 20,
                        'char' => 100,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 21,
                        'char' => 32,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 22,
                        'char' => 34,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 23,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 24,
                        'char' => 99,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 25,
                        'char' => 97,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 26,
                        'char' => 114,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 27,
                        'char' => 32,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 28,
                        'char' => 77,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 29,
                        'char' => 69,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 30,
                        'char' => 65,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 31,
                        'char' => 78,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 32,
                        'char' => 83,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 33,
                        'char' => 32,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 34,
                        'char' => 67,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 35,
                        'char' => 65,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 36,
                        'char' => 82,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 37,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 38,
                        'char' => 34,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 39,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 40,
                        'char' => 39,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 41,
                        'char' => 63,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
                1,
                4,
                // ?'=he said "<RAC SNAEM car=">' YAS UOY DID
                [
                    [
                        'pos' => 41,
                        'char' => 63,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 40,
                        'char' => 39,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 39,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 14,
                        'char' => 104,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 15,
                        'char' => 101,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 16,
                        'char' => 32,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 17,
                        'char' => 115,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 18,
                        'char' => 97,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 19,
                        'char' => 105,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 20,
                        'char' => 100,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 21,
                        'char' => 32,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 22,
                        'char' => 34,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 23,
                        'char' => 8295,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 36,
                        'char' => 82,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 35,
                        'char' => 65,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 34,
                        'char' => 67,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 33,
                        'char' => 32,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 32,
                        'char' => 83,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 31,
                        'char' => 78,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 30,
                        'char' => 65,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 29,
                        'char' => 69,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 28,
                        'char' => 77,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 27,
                        'char' => 32,
                        'i' => -1,
                        'level' => 3,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 24,
                        'char' => 99,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 25,
                        'char' => 97,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 26,
                        'char' => 114,
                        'i' => -1,
                        'level' => 4,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 37,
                        'char' => 8297,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 38,
                        'char' => 34,
                        'i' => -1,
                        'level' => 2,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 13,
                        'char' => 8294,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 12,
                        'char' => 39,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 11,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 10,
                        'char' => 89,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 9,
                        'char' => 65,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 8,
                        'char' => 83,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 85,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 79,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 89,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 32,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 73,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 0,
                        'char' => 68,
                        'i' => -1,
                        'level' => 1,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                ],
            ],
            [
                [
                    [
                        'pos' => 0,
                        'char' => 11032,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'ON',
                        'otype' => 'ON',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 99,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 12,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'WS',
                        'otype' => 'WS',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 10,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'B',
                        'otype' => 'B',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 11032,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'ON',
                        'otype' => 'ON',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 12288,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'WS',
                        'otype' => 'WS',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 10,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'B',
                        'otype' => 'B',
                        'x' => 0,
                    ],
                ],
                0,
                0,
                [
                    [
                        'pos' => 0,
                        'char' => 11032,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'ON',
                        'otype' => 'ON',
                        'x' => 0,
                    ],
                    [
                        'pos' => 1,
                        'char' => 99,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 2,
                        'char' => 12,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'WS',
                        'otype' => 'WS',
                        'x' => 0,
                    ],
                    [
                        'pos' => 3,
                        'char' => 10,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'B',
                        'otype' => 'B',
                        'x' => 0,
                    ],
                    [
                        'pos' => 4,
                        'char' => 97,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'L',
                        'otype' => 'L',
                        'x' => 0,
                    ],
                    [
                        'pos' => 5,
                        'char' => 11032,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'ON',
                        'otype' => 'ON',
                        'x' => 0,
                    ],
                    [
                        'pos' => 6,
                        'char' => 12288,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'WS',
                        'otype' => 'WS',
                        'x' => 0,
                    ],
                    [
                        'pos' => 7,
                        'char' => 10,
                        'i' => -1,
                        'level' => 0,
                        'pdimatch' => -1,
                        'type' => 'B',
                        'otype' => 'B',
                        'x' => 0,
                    ],
                ],
            ],
        ];
    }
}
